/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.wasm;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.wasm.WebAssemblyTablePrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.wasm.ToWebAssemblyIndexOrSizeNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssembly;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTable;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTableObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;

public class WebAssemblyTablePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<WebAssemblyTablePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new WebAssemblyTablePrototypeBuiltins();

    protected WebAssemblyTablePrototypeBuiltins() {
        super("Table.prototype", WebAssemblyTablePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, WebAssemblyTablePrototype builtinEnum) {
        switch (builtinEnum) {
            case grow: {
                return WebAssemblyTablePrototypeBuiltinsFactory.WebAssemblyTableGrowNodeGen.create(context, builtin, WebAssemblyTablePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case get: {
                return WebAssemblyTablePrototypeBuiltinsFactory.WebAssemblyTableGetNodeGen.create(context, builtin, WebAssemblyTablePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case set: {
                return WebAssemblyTablePrototypeBuiltinsFactory.WebAssemblyTableSetNodeGen.create(context, builtin, WebAssemblyTablePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class WebAssemblyTableSetNode
    extends JSBuiltinNode {
        @Node.Child
        ToWebAssemblyIndexOrSizeNode toIndexNode = ToWebAssemblyIndexOrSizeNode.create("WebAssembly.Table.set(): Argument 0");

        public WebAssemblyTableSetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object set(Object thiz, Object index, Object value) {
            if (!JSWebAssemblyTable.isJSWebAssemblyTable(thiz)) {
                throw Errors.createTypeError("WebAssembly.Table.set(): Receiver is not a WebAssembly.Table");
            }
            Object wasmTable = ((JSWebAssemblyTableObject)((Object)thiz)).getWASMTable();
            int indexInt = this.toIndexNode.executeInt(index);
            if (value != Null.instance && !JSWebAssembly.isExportedFunction(value)) {
                throw Errors.createTypeError("WebAssembly.Table.set(): Argument 1 must be null or a WebAssembly function");
            }
            try {
                Object setFn = InteropLibrary.getUncached((Object)wasmTable).readMember(wasmTable, "set");
                InteropLibrary.getUncached((Object)setFn).execute(setFn, new Object[]{indexInt, value});
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
            catch (Throwable throwable) {
                if (TryCatchNode.shouldCatch(throwable)) {
                    throw Errors.createRangeError(throwable, (Node)this);
                }
                throw throwable;
            }
            return Undefined.instance;
        }
    }

    public static abstract class WebAssemblyTableGetNode
    extends JSBuiltinNode {
        @Node.Child
        ToWebAssemblyIndexOrSizeNode toIndexNode = ToWebAssemblyIndexOrSizeNode.create("WebAssembly.Table.get(): Argument 0");

        public WebAssemblyTableGetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object get(Object thiz, Object index) {
            if (!JSWebAssemblyTable.isJSWebAssemblyTable(thiz)) {
                throw Errors.createTypeError("WebAssembly.Table.get(): Receiver is not a WebAssembly.Table");
            }
            int indexInt = this.toIndexNode.executeInt(index);
            Object wasmTable = ((JSWebAssemblyTableObject)((Object)thiz)).getWASMTable();
            try {
                Object getFn = InteropLibrary.getUncached((Object)wasmTable).readMember(wasmTable, "get");
                Object result = InteropLibrary.getUncached((Object)getFn).execute(getFn, new Object[]{indexInt});
                if (!InteropLibrary.getUncached((Object)result).isExecutable(result)) {
                    return Null.instance;
                }
                return result;
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
            catch (Throwable throwable) {
                if (TryCatchNode.shouldCatch(throwable)) {
                    throw Errors.createRangeError(throwable, (Node)this);
                }
                throw throwable;
            }
        }
    }

    public static abstract class WebAssemblyTableGrowNode
    extends JSBuiltinNode {
        @Node.Child
        ToWebAssemblyIndexOrSizeNode toDeltaNode = ToWebAssemblyIndexOrSizeNode.create("WebAssembly.Table.grow(): Argument 0");

        public WebAssemblyTableGrowNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object grow(Object thiz, Object delta) {
            if (!JSWebAssemblyTable.isJSWebAssemblyTable(thiz)) {
                throw Errors.createTypeError("WebAssembly.Table.grow(): Receiver is not a WebAssembly.Table");
            }
            int deltaInt = this.toDeltaNode.executeInt(delta);
            Object wasmTable = ((JSWebAssemblyTableObject)((Object)thiz)).getWASMTable();
            try {
                Object growFn = InteropLibrary.getUncached((Object)wasmTable).readMember(wasmTable, "grow");
                return InteropLibrary.getUncached((Object)growFn).execute(growFn, new Object[]{deltaInt});
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
            catch (Throwable throwable) {
                if (TryCatchNode.shouldCatch(throwable)) {
                    throw Errors.createRangeError(throwable, (Node)this);
                }
                throw throwable;
            }
        }
    }

    public static enum WebAssemblyTablePrototype implements BuiltinEnum<WebAssemblyTablePrototype>
    {
        grow(1),
        get(1),
        set(2);

        private final int length;

        private WebAssemblyTablePrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isEnumerable() {
            return true;
        }
    }
}

